<?php

defined('BASEPATH') OR exit('No direct script access allowed');
header("Access-Control-Allow-Origin: *");

class Cservicio extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('security');
        $this->load->model("Mservicio");
        $this->load->model("Minforme");
        $this->load->dbforge();
        $this->load->library('Opensslencryptdecrypt');
    }

    public function getInformePrerevision() {
        $rta=$this->Minforme->getDatoInforme(1);
        $encrptopenssl = New Opensslencryptdecrypt();
        $informe = $encrptopenssl->encrypt(json_encode($rta->result())); 
        echo $informe;
    }
    
   public function guardarDispositivo(){
        $dispositivo['mac'] = $this->input->post('serial');
        $descripcion='Dispositivo movil';
        if($this->input->post('descripcion')!==''){
            $descripcion = $this->input->post('descripcion');
        }
        $dispositivo['descripcion'] = $descripcion;
        $dispositivo['activo'] = '0';
        $rta=$this->Mservicio->guardarDispositivo($dispositivo); 
    }
    
    function getCda(){
        $rta=$this->Mservicio->getCda();
        echo $rta;
    }
    
    public function getLicencia() {
        $this->encriptar($this->Mservicio->getLicencia());
    }
    
    public function getLineas() {
        $this->encriptar($this->Mservicio->getLineas());
    }
    
    public function getConfMaquina() {
        $this->encriptar($this->Mservicio->getConfMaquina($this->input->get('idmaquina')));
    }
    
    public function encriptar($rta){
        $encrptopenssl = New Opensslencryptdecrypt();
        $datos = $encrptopenssl->encrypt(json_encode($rta->result())); 
        echo $datos;
    }
    
    public function createtable() {
        $fields = array(
            'idmercadeo' => array(
                'type' => 'INT',
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'placa' => array(
                'type' => 'VARCHAR',
                'constraint' => '10',
                'null' => FALSE,
            ),
            'tipo_vehiculo' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => FALSE,
            ),
            'clase' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => TRUE,
            ),
            'servicio' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => TRUE,
            ),
            'taximetro' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => TRUE,
            ),
            'tipo_inspeccion' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => FALSE,
            ),
            'valor' => array(
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => FALSE,
            ),
            'fecha' => array(
                'type' => 'TIMESTAMP',
                'null' => FALSE,
            ),
        );
        $this->dbforge->add_key('idmercadeo', TRUE);
        $this->dbforge->add_field($fields);
        $attributes = array('ENGINE' => 'MyISAM');
        $this->dbforge->create_table('mercadeo', TRUE, $attributes);

        $fields = array(
            'idauditoria' => array(
                'type' => 'INT',
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'placa' => array(
                'type' => 'VARCHAR',
                'constraint' => '10',
                'null' => FALSE,
            ),
            'idprueba' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => FALSE,
            ),
            'idresultado' => array(
                'type' => 'INT',
                'constraint' => '10',
                'null' => TRUE,
            ),
            'intento' => array(
                'type' => 'LONGTEXT',
                'null' => TRUE,
            ),
            'fecha' => array(
                'type' => 'TIMESTAMP',
                'null' => FALSE,
            ),
        );
        $this->dbforge->add_key('idauditoria', TRUE);
        $this->dbforge->add_field($fields);
        $attributes = array('ENGINE' => 'MyISAM');
        $this->dbforge->create_table('auditoria', TRUE, $attributes);
    }
    
    public function insertAuditoria() {
        $data ['placa'] = $this->input->post('placa');
        $data ['idprueba'] = $this->input->post('idprueba');
        $data ['idresultado'] = $this->input->post('idresultado');
        $data ['intento'] = $this->input->post('intento');
        $this->Mservicio->insertAuditoria($data);
    }
    
     public function insertMercadeo() {
        $data ['placa'] = $this->input->post('placa');
        $data ['tipo_vehiculo'] = $this->input->post('tipo_vehiculo');
        $data ['clase'] = $this->input->post('clase');
        $data ['servicio'] = $this->input->post('servicio');
        $data ['taximetro'] = $this->input->post('taximetro');
        $data ['tipo_inspeccion'] = $this->input->post('tipo_inspeccion');
        $data ['valor'] = $this->input->post('valor');
        $this->Mservicio->insertMercadeo($data);
    }
    
    

}
