<?php

defined('BASEPATH') OR exit('No direct script access allowed');
header("Access-Control-Allow-Origin: *");

class Cbackupserver extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('security');
        $this->load->model("Mbackup");
        $this->load->dbforge();
        $this->load->library('Opensslencryptdecrypt');
    }
    public function index (){
        $namebackup = $this->input->get('namebackup');
        $user = $this->input->get('user');
        
        $fields = array(
            'idbackup' => array(
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'nombre' => array(
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => FALSE,
            ),
            'usuario' => array(
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => FALSE,
            ),
            'html' => array(
                'type' => 'TEXT',
                'null' => TRUE,
            ),
            'usuariores' => array(
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => TRUE,
            ),
            'res' => array(
                'type' => 'INT',
                'null' => TRUE,
            ),
            'fechageneracion' => array(
                'type' => 'TIMESTAMP',
                'null' => FALSE,
            ),
            'fecharestauracion' => array(
                'type' => 'TIMESTAMP',
                'null' => FALSE,
            ),
        );
        $this->dbforge->add_key('idbackup', TRUE);
        $this->dbforge->add_field($fields);
        $attributes = array('ENGINE' => 'MyISAM');
        $this->dbforge->create_table('backup', TRUE, $attributes);
        $this->inserdata($namebackup,$user);
    }
    public function inserdata($namebackup,$user) {
        echo $namebackup;
        echo $user;
        $this->Mbackup->inserbackup($namebackup,$user);
        
    }
    public function updatebackup(){
        $html2 = $this->input->get('html2');
        $usercad = $this->input->get('usercad');
        $idbackup = $this->input->get('idbackup');
        $this->Mbackup->updatebackup($html2,$usercad,$idbackup);
    }
    
}